if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

local portal_in = resize.location.portal_in
local sensor = resize.location.sensor_position
local sensor_rect = Rectangle.new(sensor, sensor)
local random_input = resize.location.generate_target:translate(Vector.new(2, 0))
local output_1 = resize.location.std.checkers[1].dispose:translate(Vector.new(-2, 0))
local output_2 = resize.location.std.checkers[2].dispose:translate(Vector.new(-2, 0))

local default_vertical = 0.5;
state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

set_default_vertical(default_vertical)
function tutorial_routine_first()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    embed(ramp(4, do_all(
      announce_lambda("This input randomly creates two kinds of shape.", 0.05),
      bouncing_arrow_at_game_lambda(random_input, 0.06, LEFT)
    ), captured_cancel()))
    embed(ramp(4, do_all(
      announce_lambda("We need to sort them.", 0.07),
      bouncing_arrow_at_game_lambda(output_1, 0.06, RIGHT),
      bouncing_arrow_at_game_lambda(output_2, 0.06, RIGHT)
    ), captured_cancel()))

    embed(ramp(4, do_all(
      announce_lambda("This sensor will help us.", 0.1),
      bouncing_arrow_at_game_lambda(sensor_rect, 0.06, UP),
      glowing_box_at_game_lambda(sensor_rect)
    ), captured_cancel()))
    set_user_input_filter(only_play_filter)
    state:suppress_transport_menu(false);
    embed(pause(0.25))
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on the factory.", 0.1))
    ))
    embed(pause_until(function() return state.grid:ticks() >= 17 end))
    embed(announce("The sensor creates a signal when it see something.", 5, 0.05, captured_cancel()))
    embed(announce("But it's not wired to anything right now.", 5, 0.05, captured_cancel()))
    embed(ramp_until(function() return false end, do_all(
      announce_lambda("Try again", 0.1),
      highlight_menu_item_lambda("stop_button")
    )))
  end)
end
function wire_positions()
  local ret = {}
  for i,v in pairs(state.grid:entities()) do
    if v.type == "Wire" then
      if v.source.where == sensor then
        table.insert(ret, v.target.where)
      elseif v.target.where == sensor then
        table.insert(ret, v.source.where)
      end
    end
  end
  return ret
end
function table_contains(t, v)
  for _, x in pairs(t) do
    if x == v then
      return true
    end
  end
  return false
end
function wire_count()
  return #wire_positions()
end
function draw_missing_wires_lambda()
  local a = bouncing_arrow_at_game_lambda(portal_in, 0.06, LEFT)
  local b = bouncing_arrow_at_game_lambda(portal_in, 0.06, RIGHT)
  return function(c, fade)
    local pos = wire_positions()
    if not table_contains(pos, portal_in.lesser) then
      b(c, fade)
    end
    if not table_contains(pos, portal_in.greater) then
      a(c, fade)
    end
  end
end
function only_wire_filter(i)
  return i == PlayerInteraction.wire
end
function is_wire_open()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialCreateWire"
end
function is_done()
  return wire_count() == 2
end
local function wiring_status()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreateWire" then
    if not partial.source_set then
      if partial.source and partial.source.where == sensor and partial.source.index == 0 then
        return "source okay"
      else
        return "source bad"
      end
    else
      if partial.target and portal_in:contains(partial.target.where) then
        return "target okay"
      else
        return "target bad"
      end
    end
  else
    return "not wiring"
  end
end
local function wiring_interaction_filter(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click then
      return true
    elseif i.event == MouseEventAction.lmb_click then
      local status = wiring_status()
      return status == "source okay" or status == "target okay"
    end
  elseif i.type == "MouseUpdateAction" then
    return true
  end
  return i == PlayerInteraction.cancel or i == PlayerInteraction.wire
end
local first_wire_created = false
function tutorial_routine_second()
  return coroutine.wrap(function()
    if not is_done() then
      embed(ramp(4, do_all(
        announce_lambda("Let's wire the sensor to the portals.", 0.05)
      ), captured_cancel()))
      state:suppress_toolbar_menu(false);
      embed(pause(0.2))
    end
    while not is_done() or is_wire_open() do
      set_user_input_filter(only_wire_filter)
      embed(ramp_until(is_wire_open, do_all(
        announce_lambda("Tool: Wire", 0.2),
        highlight_menu_item_lambda("toolbar_8")
      )))
      set_user_input_filter(wiring_interaction_filter)
      if wire_count() < 1 then
        embed(ramp_while(
          function() return wiring_status() == "source bad" or wiring_status() == "source okay" end,
          do_all(
            announce_lambda("Click on the positive sensor node to create a wire.", 0.06),
            bouncing_arrow_at_game_lambda(sensor_rect, 0.06, LEFT)
          )
        ))
        embed(ramp_while(
          function() return wiring_status() == "target bad" or wiring_status() == "target okay" end,
          do_all(
            announce_lambda("Click on a portal to connect a wire.", 0.06),
            announce_lambda("When a portal receives a signal, it deactivates.", 0.05, default_vertical - 0.07),
            bouncing_arrow_at_game_lambda(portal_in, 0.06, LEFT),
            bouncing_arrow_at_game_lambda(portal_in, 0.06, RIGHT)
          )
        ))
        if not first_wire_created and wire_count() == 1 then
          first_wire_created = true
          embed(announce("This portal will now deactivate when the sensor sees something.", 4, 0.05, captured_cancel()))
        end
      end
      if wire_count() == 1 then
        embed(ramp_while(
          function() return wire_count() == 1 and wiring_status() == "source bad" or wiring_status() == "source okay" end,
          do_all(
            announce_lambda("Click on the positive sensor node to create another wire.", 0.06),
            bouncing_arrow_at_game_lambda(sensor_rect, 0.06, LEFT)
          )
        ))
        embed(ramp_while(
          function() return wire_count() == 1 and wiring_status() == "target bad" or wiring_status() == "target okay" end,
          do_all(
            announce_lambda("Click on the other portal to create a wire.", 0.06),
            announce_lambda("When a portal receives a signal, it deactivates.", 0.05, default_vertical - 0.07),
            draw_missing_wires_lambda()
          )
        ))
      end
      if wire_count() == 2 then
        set_user_input_filter(only_play_or_cancel_filter)
        embed(ramp_while(function() return is_wire_open() and wire_count() == 2 end, do_all(
          announce_lambda("Right click far from a wire to close wiring panel.", 0.08),
          announce_lambda("(Or press Escape)", 0.06, default_vertical - 0.08)
        )))
      end
      embed(pause(0.01))
    end
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(pause_until(function() return state.grid:ticks() >= 15 end))
    embed(announce("The portal deactivates when a square triggers the sensor", 3, 0.045, captured_cancel()))
    embed(announce("This allows us to sort the shapes properly!", 3, 0.06, captured_cancel()))
  end)
end
function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  else
    return tutorial_routine_second()
  end
end
draw_interpreted_routine(tutorial_routine())


--[[
state:filter_interactions(function(i)
  if i.type == "Destroy" then
    if portal_in:contains(i.where) then
      return "Cannot delete the portals."
    elseif portal_out:contains(i.where) then
      return "Cannot delete the portals."
    end
  end
end)
]]
